﻿Voxco = { onPageReady: $(document).ready };

var a4 = {
    const: CONTENT_TYPE_MULTIPART_FORMDATA = "multipart/form-data",
    const: CONTENT_TYPE_APPLICATION_JSON = "application/json; charset=utf-8",
    sessionCountDown: null,
    language: $("html").attr("lang"),
    baseUrl: null,
    host: null,
    lastError: null,
    hasCommandCenter: $("#HasCommandCenter").val() == "True",
    hasAcuity4: $("#HasA4S").val() == "True",
    parseAjaxError: function (xhr, msg, e) {
        var error;
        var hasCC = $("#HasCommandCenter").val();

        try {
            if (xhr.responseText && xhr.responseText.length > 0) {
                error = eval("(" + xhr.responseText + ")");
            }

            if (xhr.status == 401) { //Unauthorized
                var controller = (hasCC && hasCC == "True") ? "MultiMode" : "Account";
                a4.top().window.location = a4.getAction("LogOff", controller);
            }
            else if (xhr.status == 403) { //Forbidden
                a4.top().window.location = a4.getAction("PermissionDenied", "Home");
            }
            else if (typeof error === "undefined") {
                error = {};

                if (typeof e !== "undefined" && typeof e.message !== "undefined")
                    error.Message = e.message;
                else
                    error.Message = xhr.statusText;
            }
        }
        catch (ex) {
            console.error(ex);

            error = { Message: sharedResources.UnexpectedError };
        }

        return error;
    },
    onAjaxPageMethodError: function (xhr, msg, e) {
        if (a4.ajaxRequestTimer)
            window.clearTimeout(a4.ajaxRequestTimer);

        a4.ajaxRequestInProcess = false;
        $("body").removeClass("wait");
        a4.hideBusyBox();

        var error = a4.parseAjaxError(xhr, msg, e);

        if (error) {
            a4.lastError = error;
            a4.showErrorMessage(error);
        }
    },
    ajaxCache: {},
    getAjaxCacheKey: function (action, data) {
        return (action + JSON.stringify(data || "")).replace(/[^\w]+/ig, "").toUpperCase();
    },
    clearAjaxCache: function (action, data) {
        if (!action) {
            a4.ajaxCache = {};
        }
        else {
            var ajaxCacheKey = a4.getAjaxCacheKey(action, data);

            if (!a4.ajaxCache[ajaxCacheKey]) {
                ajaxCacheKey = _.findKey(a4.ajaxCache, function (value, key) {
                    return key.startsWith(ajaxCacheKey);
                });
            }

            delete a4.ajaxCache[ajaxCacheKey];
        }
    },
    callFileFormDataServerMethod: function (action, file, data, onProgress, onSuccess, onError, additionalSettings) {
        var settings = additionalSettings || {};
        settings.position = settings.position || 0;
        settings.chunkSize = settings.chunkSize || 1024 * 1024 * 5;
        settings.blobKey = settings.blobKey || "blob";
        settings.positionKey = settings.positionKey || "position";

        var formData = new FormData();

        if (data !== undefined && data !== null) {
            for (var key in data) {
                if (data.hasOwnProperty(key)) {
                    formData.set(key, _.result(data, key));
                }
            }
        }

        var blob = file.slice(settings.position, settings.position + settings.chunkSize, file.type);
        formData.set(settings.blobKey, blob, file.name);
        formData.set(settings.positionKey, settings.position);

        settings.data = formData;
        settings.contentType = settings.contentType || CONTENT_TYPE_MULTIPART_FORMDATA;
        settings.processData = false;

        a4.callServerMethod(action, null, function (result) {
            settings.position = settings.position + settings.chunkSize;
            if (settings.position >= file.size) {
                onSuccess(result);
            }
            else {
                onProgress(result, settings.position);
                a4.callFileFormDataServerMethod(action, file, data, onProgress, onSuccess, onError, settings);
            }
        }, onError, settings);
    },
    callServerMethod: function (action, data, onSuccess, onError, additionalSettings) {
        var ajaxCacheKey;

        if (additionalSettings && additionalSettings.cacheRequest) {
            delete additionalSettings.cacheRequest;
            ajaxCacheKey = a4.getAjaxCacheKey(action, data);

            if (a4.ajaxCache[ajaxCacheKey]) {
                return a4.ajaxCache[ajaxCacheKey];
            }
        }

        var args = '';
        var blockElementTimer;

        if (data !== undefined && data !== null) {
            args = {};

            for (var key in data) {
                if (data.hasOwnProperty(key))
                    args[key] = _.result(data, key); //Check if the property is a function. If true, it returns the result of the function, otherwise it returns the property value.
            }
        }

        if (a4.ajaxPendingCalls == 0) {
            if (a4.busyBoxEnabled) {
                a4.ajaxRequestTimer = setTimeout(function () { a4.showBusyBox(); }, a4.busyBoxTimeout);
            }

            $("body").addClass("wait");
            a4.ajaxRequestInProcess = true;
        }

        a4.ajaxPendingCalls++;
        var settings = additionalSettings || {};

        var blockElement = settings.blockElement || null;
        var blockElementTimeout = settings.blockElementTimeout != undefined ? settings.blockElementTimeout : 800;

        if (blockElement) {
            blockElementTimer = setTimeout(function () {
                blockElement.block();
            }, blockElementTimeout);
        }

        var customCompleteFunction = null;
        if (typeof additionalSettings !== "undefined" && additionalSettings.complete) {
            var customCompleteFunction = additionalSettings.complete;
        }

        if (typeof aft != "undefined" && aft != null && aft)
            settings.headers = { "X-CSRF-TOKEN": $(aft).val() };

        settings.type = settings.type || "POST";
        settings.url = action;
        settings.data = settings.data || JSON.stringify(args);
        settings.contentType = settings.contentType === CONTENT_TYPE_MULTIPART_FORMDATA ? false : settings.contentType || CONTENT_TYPE_APPLICATION_JSON;
        settings.dataType = settings.dataType || "json"; //Review this. Not every call is json
        settings.success = onSuccess;
        settings.error = onError || a4.onAjaxPageMethodError;
        settings.complete = function (data, textStatus) {
            if (ajaxCacheKey) {
                a4.ajaxCache[ajaxCacheKey] = data.responseJSON;
            }

            if (blockElement) {
                window.clearTimeout(blockElementTimer);
                blockElement.unblock();
            }

            a4.ajaxPendingCalls--;

            if (a4.ajaxPendingCalls == 0) {
                if (a4.ajaxRequestTimer != null) {
                    window.clearTimeout(a4.ajaxRequestTimer);
                }

                a4.ajaxRequestInProcess = false;
                $("body").removeClass("wait");

                if (a4.busyBoxEnabled) {
                    a4.hideBusyBox();
                }
            }

            if (customCompleteFunction) {
                customCompleteFunction(data, textStatus);
            }
        }

        return $.ajax(settings);
    },
    ajaxPendingCalls: 0,
    ajaxRequestInProcess: false,
    ajaxRequestTimer: null,
    busyBoxEnabled: false,
    busyBoxTimeout: 2000,
    showBusyBox: function () {
        $.blockUI();
    },
    hideBusyBox: function () {
        $.unblockUI();
    },
    showErrorMessage: function (error, timeout) {
        var errorLinks = null;
        var message = "";

        if (error && typeof (error) === 'object') {
            if (!error.IsApplicationException && error.Trace) {
                errorLinks = $("<p class='errorLinks' />").append($("<a href='#' />").html(sharedResources.ViewErrorDetails).click(function () {
                    $.noty.closeAll();
                    var displayErrorDetailsResources = { "Title": sharedResources.ErrorDetails, "Message": "", "CancelButton": sharedResources.Close };
                    modalDialog.renderSimpleFormDialog(displayErrorDetailsResources, [{ Label: null, Name: "Items", Value: error.Trace, Type: "textarea", Style: "width: 100%; box-sizing: border-box; border: 0;" }]);
                }), $("<a href='#' />").html(sharedResources.ReportError).click(function () {
                    $.noty.closeAll();
                    modalDialog.showWindow(a4.baseUrl + 'Home/Contact/', 500, 500);
                }));
            }

            message = $("<span />", { text: error.Message });

            if (errorLinks && errorLinks.length > 0) {
                message.append(errorLinks);
            }
        }
        else {
            message = error;
        }

        var notification = {
            theme: "a4s",
            type: "error",
            layout: "center",
            text: message,
            closeWith: ['button', 'click'],
            template: '<div class="noty_message">' + voxco.icons.getIcon("warning") + '<span class="noty_text"></span>' + voxco.icons.getIcon("close", "noty_close") + '</div>',
            animation: {
                open: 'animated flipInX',
                close: 'animated flipOutX'
            },
            killer: true,
            maxVisible: 1
        }

        if (timeout) {
            notification["timeout"] = timeout;
        }

        noty(notification);
    },
    hideErrorMessage: function (id) {
        if (id) {
            $.noty.close(id);
        }
        else {
            $.noty.closeAll();
        }
    },
    showSuccessMessage: function (content, timeout) {
        if (timeout == undefined)
            timeout = 5000;

        return noty({
            theme: "a4s",
            type: "success",
            layout: "center",
            text: content,
            closeWith: ['button'],
            template: '<div class="noty_message"><span class="noty_text"></span>' + voxco.icons.getIcon("close", "noty_close") + '</div>',
            timeout: timeout,
            animation: {
                open: 'animated flipInX',
                close: 'animated flipOutX'
            }
        });
    },
    openSurveyWindow: function (surveyUrl) {
        window.open(surveyUrl, '_blank', 'toolbar=0, location=1, menubar=0, resizable=1, scrollbars=1, width=1024, height=768');
    },
    testSurvey: function (useS2, surveyToken) {
        var surveyUrl;
        var tui = new Date().getTime();

        if (useS2)
            surveyUrl = $("#S2BaseUrl").val() + "?st=" + surveyToken + "&m=0" + "&tui=" + tui + "&dlang=" + a4.language + "&nocookie=";
        else
            surveyUrl = $("#SurveyEngineBaseUrl").val() + "Test/?st=" + surveyToken + '&tui=' + tui + "&nocookie=";

        a4.openSurveyWindow(surveyUrl);
    },
    previewSurvey: function (useS2, surveyToken) {
        var surveyUrl;
        var tui = new Date().getTime();

        if (useS2)
            surveyUrl = $("#S2BaseUrl").val() + "?st=" + surveyToken + "&m=1" + "&tui=" + tui + "&dlang=" + a4.language + "&nocookie=";
        else
            surveyUrl = $("#SurveyEngineBaseUrl").val() + "Preview/?st=" + surveyToken + '&tui=' + tui + "&nocookie=";

        a4.openSurveyWindow(surveyUrl);
    },
    takeSurvey: function (useS2, surveyToken) {
        var surveyUrl;
        var tui = new Date().getTime();

        if (useS2)
            surveyUrl = $("#S2BaseUrl").val() + "?st=" + surveyToken + "&m=2" + "&tui=" + tui + "&nocookie=";
        else
            surveyUrl = $("#SurveyEngineBaseUrl").val() + "?st=" + surveyToken + '&tui=' + tui + "&nocookie=";

        a4.openSurveyWindow(surveyUrl);
    },
    viewSurveyResponses: function (useS2, surveyToken, download) {
        if (useS2)
            surveyUrl = $("#S2BaseUrl").val() + "?st=" + surveyToken + "&m=2&vr=1";
        else
            surveyUrl = $("#SurveyEngineBaseUrl").val() + "Print.aspx/?st=" + surveyToken;

        if (download)
            window.location = surveyUrl += "&download=1";
        else
            window.open(surveyUrl, '_blank', 'toolbar=0, location=1, menubar=0, resizable=1, scrollbars=1, width=1024, height=768');
    },
    absoluteRedirect: function (viewName) {
        window.location = a4.baseUrl + viewName;
    },
    getAction: function (action, controller, area, params) {
        var baseUrl = a4.baseUrl;

        area = (area || "");

        //It doesn't work for all cases. Must be improved
        //if ((/survey/i).test(area))
        //    return a4.getSurveyAction(action, controller, params);
        //if ((/project/i).test(area))
        //    return a4.getProjectAction(action, controller, params);
        if (!(/home/i).test(area))
            baseUrl += area + "/";

        var url = baseUrl + controller + "/" + action + "/";

        if (params && params.id) {
            url += params.id;
            delete params.id;
        }

        url += a4.getQueryStringParams(params);

        return url;
    },
    getSurveyAction: function (action, controller, params) {
        var surveyId = a4.getSurveyId();

        if (params && params.surveyId) {
            surveyId = params.surveyId;
            delete params.surveyId;
        }

        return a4.baseUrl + "Survey/" + controller + "/" + action + "/" + surveyId + a4.getQueryStringParams(params);
    },
    getSurveyId: function () {
        return $("#SurveyId").val() || 0;
    },
    getProjectAction: function (action, controller, params) {
        var projectId = $("#ProjectId").val() || 0;

        if (params && params.projectId) {
            projectId = params.projectId;
            delete params.projectId;
        }

        return a4.baseUrl + "Project/" + controller + "/" + action + "/" + projectId + a4.getQueryStringParams(params);
    },
    getAgentAssignmentAction: function (action, controller) {
        return a4.baseUrl + "Project/" + controller + "/" + action;
    },
    getQueryStringParams: function (params) {
        var queryString = "";

        if (params) {
            var qsParams = _.map(params, function (val, key) {
                if (Array.isArray(val))
                    return _.map(val, function (aVal, aKey) {
                        return key + "=" + encodeURIComponent(aVal);
                    }).join("&");
                else if (val != null)
                    return key + "=" + encodeURIComponent(val);
            });

            if (qsParams && qsParams.length > 0)
                queryString = "?" + qsParams.join("&");
        }

        return queryString;
    },
    ie: function () {
        try {
            var ua = window.navigator.userAgent;
            var msie = ua.indexOf('MSIE ');
            if (msie > 0) {
                // IE 10 or older => return version number
                return parseInt(ua.substring(msie + 5, ua.indexOf('.', msie)), 10);
            }

            var trident = ua.indexOf('Trident/');
            if (trident > 0) {
                // IE 11 => return version number
                var rv = ua.indexOf('rv:');
                return parseInt(ua.substring(rv + 3, ua.indexOf('.', rv)), 10);
            }

            var edge = ua.indexOf('Edge/');
            if (edge > 0) {
                // Edge (IE 12+) => return version number
                return parseInt(ua.substring(edge + 5, ua.indexOf('.', edge)), 10);
            }
        }
        catch (e) {
        }

        // other browser
        return false;
    },
    getTooltipQuestionText: function (autocomplete, tooltip, questionnaireId, questionId) {
        if (window.location.href.indexOf("Analyze/PortalResults") !== -1)
            return;

        a4.callServerMethod(a4.getSurveyAction("GetQuestionText", "Questionnaire"), {
            questionnaireId: questionnaireId, questionId: questionId
        },
            function (result) {
                autocomplete.attr("title", result);
                if (tooltip != null)
                    tooltip.html(result).toggle(result != null && result != "");
            }
        );
    },
    readCookie: function (name) {
        var nameEQ = name + "=";
        var ca = document.cookie.split(';');
        for (var i = 0; i < ca.length; i++) {
            var c = ca[i];
            while (c.charAt(0) == ' ') c = c.substring(1, c.length);
            if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length, c.length);
        }
        return null;
    },
    setCookie: function (name, value, days) {
        if (days) {
            var date = new Date();
            date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
            var expires = "; expires=" + date.toGMTString();
        }
        else var expires = "";
        document.cookie = name + "=" + value + expires + "; path=/";
    },
    getPageCookieName: function (version) {
        var pathName = window.location.pathname;
        var page = pathName.substring(pathName.indexOf('/') + 1);
        return "A4S_" + version + "_" + page;
    },
    disableEnter: function (e) {
        return (e.keyCode != 13);
    },
    fixPostForInput: function (selector) {
        $(selector).find(':input[type=text]:not(.enableEnter)').off('keypress.fixpost')
            .on('keypress.fixpost', function (e) { return a4.disableEnter(e); });
    },
    getInputValue: function (input) {
        var value;

        if (input.is("input:checkbox") || input.is("input:radio")) {
            if (input.attr("value") && input.attr("value") !== "on")
                value = input.is(":checked") ? input.val() : "";
            else
                value = input.is(':checked');
        }
        else if (input.is(".rich-text-editor")) {
            value = input.a4richTextEditor("getContent");
        }
        else if (input.is(".autocomplete:not([readonly])")) {
            value = input.a4autocomplete("getValue");
        }
        else if (input.is(".selectized")) {
            value = _.map(input[0].selectize.items, function (i) {
                return input[0].selectize.options[i];
            });
        }
        else if (input.is("span") || input.is("div") || input.is(".v-qeRichEditText")) {
            value = input.html();
        }
        else if (input.data("value")) {
            value = input.data("value");
        }
        else {
            value = input.val();
        }

        return value;
    },
    setInputValue: function (input, value) {
        if (input && input.length > 0) {
            if (_.isNumber(value)) {
                value = String(value);
            }

            if (input.is(":checkbox") || input.is("input:radio")) {
                if (input.attr("value") && input.attr("value") !== "on")
                    input.filter("[value='" + value + "']").prop("checked", true);
                else
                    input.prop("checked", !!value);
            }
            else if (input.is(".rich-text-editor")) {
                input.a4richTextEditor("setContent", value);
            }
            else if (input.is(".autocomplete")) {
                input.a4autocomplete("setValue", value);
            }
            else if (input.is("span") || input.is("div") || input.is(".v-qeRichEditText")) {
                input.html(value || "");
            }
            else {
                input.val(value || "");
            }
        }
    },
    isInputEnabled: function (input) {
        if (input.is(".rich-text-editor"))
            return input.closest(".rich-text-container").is(":visible") && input.is(":enabled");
        else
            return input.is(":visible:enabled")
    },
    enableInput: function (input) {
        //To be implemented
    },
    disableInput: function (input) {
        //To be implemented
    },
    clearInputValidation: function (input) {
        if (input.hasClass("input-validation-error")) {
            var inputName = input.attr("name");
            $("span.field-validation-error[data-valmsg-for='" + inputName + "']").addClass("field-validation-valid").removeClass("field-validation-error").text("");
            input.removeClass("input-validation-error");
        }
    },
    triggerInputError: function (input, errorMessage) {
        if (input.val()) {
            var inputName = input.attr("name");
            $("[data-valmsg-for='" + inputName + "']").addClass("field-validation-error").removeClass("field-validation-valid").text(errorMessage);
            input.addClass("input-validation-error");
        }
    },
    validateRequiredFields: function (context) {
        var errorMessage = (typeof resources !== 'undefined') ? resources.RequiredField : $(".v-requiredFieldMessage").val();
        var requiredFields = $(".v-requiredField", context);
        var isValid = true;

        requiredFields.each(function () {
            var isEnabled = a4.isInputEnabled($(this));
            var value = a4.getInputValue($(this));

            if (isEnabled && (!value || value.length == 0)) {
                isValid = false;
                var error = $("[data-valmsg-for='" + $(this).attr("name") + "']", context);

                $(this).addClass("input-validation-error");
                error.removeClass("field-validation-valid").addClass("field-validation-error").text(errorMessage);

                $(this).on("change", function () {
                    a4.clearInputValidation($(this));
                });
            }
        });

        return isValid;
    },
    validateEmail: function (email) {
        var filter = /^([a-zA-Z0-9_\.\-\'])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
        return filter.test(email);
    },
    validatePhone: function (phone) {
        //var filter = /^(0?(\d){9,10}|\+?1?\s?\(?(\+?[0-9]{3,5})\)?[-\s\.]{1}([0-9]{3})[-\s\.]{1}([0-9]{4}))$/;
        var filter = /^([(\-\s\.\+]*[0-9][)\-\s\.]*){5,15}$/;
        return filter.test(phone);
    },
    cleanPhone: function (value) {
        var exp = /[^(\d|\-)]/g;
        return value.replace(exp, '');
    },
    validateNumberKeyCode: function (event, allowNegative, value, maxLength) {
        // Allow backspace and delete
        // Ensure that it is a number and stop the keypress (0-9 are ascii code 48 to 57)
        if ((event.shiftKey && event.which != 9)
            || !(event.which == 0 // For FireFox
                || event.which == 46 || event.which == 8 || event.which == 45 || event.which == 9      // delete,  backspace, and tab
                || ((event.which == 109 || event.which == 189 || event.which == 45) && allowNegative && (!value || value.length == 0))
                || event.which == 37 || event.which == 39         // left and right arrow
                || (event.which >= 48 && event.which <= 57)
                || (event.which >= 96 && event.which <= 105))     // numberpad 0 to 9
            || ((value && maxLength) && (((48 <= event.which && event.which <= 57) || (96 <= event.which && event.which <= 105)) && (value.length + 1) > maxLength))) {
            event.preventDefault();
            return false;
        }

        return true;
    },
    countEmails: function (emails) {
        var count = 0
        if (emails.length > 0) {
            count = _.compact(emails.match(/@{1}[^\n,;\s]*[\n,;\s]?/g)).length;
        }
        return count;
    },
    countPhones: function (data) {
        var count = 0;
        var phones = data.split(/[\n,;]/g);

        _.each(phones, function (p) {
            var phone = p.split(",");

            if (p != "" && a4.validatePhone(p)) {
                count++;
            }
        });

        return count;
    },
    validateNameKeyCode: function (event) {
        // Allow backspace and delete
        if (!(event.which == 0 // For FireFox
            || event.which == 8
            || event.which == 32  // Space
            || event.which == 45
            || event.which == 95
            || (event.which >= 48 && event.which <= 57)
            || (event.which >= 65 && event.which <= 90)
            || (event.which >= 97 && event.which <= 122)
        )) {
            event.preventDefault();
            return false;
        }

        return true;
    },
    inIFrame: function (element) {
        var window = element ? a4.getElementWindow(element) : window;

        try {
            return window.self !== window.top;
        } catch (e) {
            return true;
        }
    },
    getIFrameTop: function () {
        var windowTop = null;

        for (var i = 0; windowTop == null && i < window.top.frames.length; i++) {
            try {
                var frame = window.top.frames[i];

                if (frame && frame.location && frame.location.host == window.location.host && frame.location.href.toLowerCase().indexOf(a4.baseUrl) == 0) {
                    windowTop = frame;
                }
            }
            catch (e) {
            }
        }

        return windowTop || window.self;
    },
    getElementWindow: function (element) {
        if (element.context && element.context.ownerDocument && element.context.ownerDocument.defaultView) {
            return element.context.ownerDocument.defaultView;
        }
        else {
            return window;
        }
    },
    top: function (element) {
        var windowTop = element ? a4.getElementWindow(element).top : window.top;
        try {
            if (window.self.location.host != windowTop.location.host || windowTop.location.href.toLowerCase().indexOf(a4.baseUrl) == -1) {
                windowTop = a4.getIFrameTop();
            }
        }
        catch (e) {
            windowTop = a4.getIFrameTop();
        }

        return windowTop;
    },
    parent: function (element) {
        var windowParent = element ? a4.getElementWindow(element).parent : window.parent;

        try {
            if (window.self.location.host != windowParent.location.host || windowParent.location.href.toLowerCase().indexOf(a4.baseUrl) == -1) {
                windowParent = window.self;
            }
        }
        catch (e) {
            windowParent = window.self;
        }

        return windowParent;
    },
    htmlEntityMap: {
        "&": "&amp;",
        "<": "&lt;",
        ">": "&gt;",
        '"': '&quot;',
        "'": '&#39;',
        "/": '&#x2F;'
    },
    escapeHtml: function (value) {
        return String(value).replace(/[&<>"'\/]/g, function (s) {
            return a4.htmlEntityMap[s];
        });
    },
    closeHtmlTags: function (html) {
        var openedtags = html.match(/<([^(\/|<)]+)>/g) //put all opened tags into an array
        var closedtags = html.match(/<\/([^>]+)>/g);

        if (_.size(openedtags) == _.size(closedtags)) {
            return html;
        }

        // Remove html
        var div = document.createElement("div");
        div.innerHTML = html;
        html = div.innerHTML;

        return html;
    },
    stripHtml: function (value) {
        return $("<div/>").html(value).text();
    },
    stripScripts: function (value) {
        var div = document.createElement('div');
        div.innerHTML = value;
        var scripts = div.getElementsByTagName('script');
        var i = scripts.length;
        while (i--) {
            scripts[i].parentNode.removeChild(scripts[i]);
        }
        return div.innerHTML;
    },
    encodeHtml: function (value) {
        return $("<textarea/>").text(value).html();
    },
    decodeHtml: function (value) {
        return $('<textarea/>').html(value).text();
    },
    boolLabel: function (b) {
        return b ? sharedResources.Yes : sharedResources.No;
    },
    initializeInputs: function (context) {
        $(".h-autonumeric", context).autoNumeric();
        $(".h-datepicker", context).datepicker();
        $(".h-timepicker", context).datetimepicker({ timeOnly: true });
        $(".h-datetimepicker", this.context).datetimepicker();
    },
    initializeDropDowns: function () {
        var lastOpened;
        var timer;

        var closeDropDown = function (container, dropdown) {
            timer = null;
            container.removeClass("open");
            container.off("mouseenter");
            container.off("mouseleave");

            if (dropdown.length > 0) {
                dropdown.hide();
                dropdown.off("mouseenter");
                dropdown.off("mouseleave");
            }

            $(document).off("click.dropdown");

            container.trigger("close.dropdown");
        };

        //Prevent to close the menu when clicking on sub-menu root
        $(document).on("click", ".button-group .dropdown-menu li, .mega-menu-toggle li", function (e) {
            if ($(e.target).next(".dropdown-submenu").length > 0) {
                e.stopPropagation();
            }
        });

        $(document).on("click", ".dropdown-container, .mega-menu-toggle", function (e) {
            var container = $(this);
            var dropdown = $(".dropdown-menu", container);
            var dialog = $(container).closest(".dialog-main");

            if (dropdown.length == 0) {
                var dropdownId = container.attr("data-dropdownId");
                //Menu is outside
                if (dropdownId) {
                    dropdown = $(".dropdown-menu#" + dropdownId);
                    dropdown.show();
                    dropdown.position({
                        my: "right top",
                        at: "right bottom",
                        of: container,
                        collision: "flipfit",
                        within: dialog.length > 0 ? ".content" : window });
                }
            }

            if (lastOpened && lastOpened.container[0] != container[0]) {
                closeDropDown(lastOpened.container, lastOpened.dropdown);
            }

            if (!container.hasClass("open")) {
                container.addClass("open");

                if (dropdown.length > 0) {
                    dropdown.show();

                    $(":input:first", dropdown).trigger("focus");
                }

                container.add(dropdown).on("mouseenter", function (e) {
                    if (timer) {
                        window.clearTimeout(timer);
                        timer = null;
                    }
                });

                container.add(dropdown).on("mouseleave", function (e) {
                    if (!timer) {
                        timer = window.setTimeout(function () { closeDropDown(container, dropdown); }, 600);
                    }
                });

                $(document).on("click.dropdown", function (e) {
                    closeDropDown(lastOpened.container, lastOpened.dropdown);

                    if (timer) {
                        window.clearTimeout(timer);
                        timer = null;
                    }

                    e.stopPropagation();
                });

                container.trigger("open.dropdown");
            }
            else {
                closeDropDown(container, dropdown);

                if (timer) {
                    window.clearTimeout(timer);
                    timer = null;
                }
            }

            lastOpened = { container: container, dropdown: dropdown };

            e.stopPropagation();
        });

        $(document).on("click", ".dropdown-menu.keep-open", function (e) {
            e.stopPropagation();
        });
    },
    setInputFocus: function (context) {
        $("input:text, textarea", context).not("[disabled],[readonly]").first().trigger("focus");
    },
    conditionEvaluatorRegEx: /\[(.+?)\]/g,
    evaluateCondition: function (condition, data) {
        var valid = true;

        if (typeof (condition) != 'undefined' && condition != null) {
            try {
                if (_.isFunction(condition)) {
                    valid = condition(data || {});
                }
                else if (_.isString(condition)) {
                    var expression = condition.replace(a4.conditionEvaluatorRegEx, function (match, capture) {
                        if (!data)
                            return undefined;
                        else if (_.isString(data[capture]))
                            return "'" + _.escape(data[capture]) + "'";
                        else if (_.isObject(data[capture]))
                            return JSON.stringify(data[capture]);
                        else
                            return data[capture];
                    });

                    if (expression) {
                        valid = !!eval(expression);
                    }
                }
                else {
                    valid = !!condition;
                }
            }
            catch (ex) {
                if (console)
                    console.error(ex);
            }
        }

        return valid;
    },
    showSelectProjectDialog: function (callback, title, hideProjectId, confirmDialogResources, showRoleOnly) {
        if (!hideProjectId)
            hideProjectId = $("#ProjectId").val() || 0;

        var params = {
            title: title || "",
            hideProjectId: hideProjectId,
            confirmDialogResources: _.escape(JSON.stringify(confirmDialogResources)) || "",
            showRoleOnly: showRoleOnly
        };

        modalDialog.showWindow(a4.getProjectAction("SelectProject", "Shared", params), 300, 600, {
            afterClose: function () {
                var topWindow = a4.top();
                if (topWindow.selectedProjectId) {
                    callback(topWindow.selectedProjectId);
                    topWindow.selectedProjectId = undefined;
                }
            }
        });
    },
    formatDate: function (date) {
        return $.datepicker.formatDate(dateFormat, date);
    },
    dateAdd: function (date, interval, units) {
        var ret = new Date(date); //don't change original date
        switch (interval.toLowerCase()) {
            case 'year': ret.setFullYear(ret.getFullYear() + units); break;
            case 'quarter': ret.setMonth(ret.getMonth() + 3 * units); break;
            case 'month': ret.setMonth(ret.getMonth() + units); break;
            case 'week': ret.setDate(ret.getDate() + 7 * units); break;
            case 'day': ret.setDate(ret.getDate() + units); break;
            case 'hour': ret.setTime(ret.getTime() + units * 3600000); break;
            case 'minute': ret.setTime(ret.getTime() + units * 60000); break;
            case 'second': ret.setTime(ret.getTime() + units * 1000); break;
            default: ret = undefined; break;
        }
        return ret;
    },
    updateUnreadMessagesCount: function () {
        var messagesCountContainer = $("#menu-bar .action.messages .count-bubble");

        a4.callServerMethod(a4.getAction("GetUnreadMessagesCount", "Shared", "Home"), {}, function (result) {
            if (result == 0) {
                if (messagesCountContainer.length > 0) {
                    messagesCountContainer.hide();
                }
            }
            else {
                if (messagesCountContainer.length == 0) {
                    $("#menu-bar .action.messages .fa-envelope").append($("<span />", { "class": "count-bubble" }).append(result));
                }
                else {
                    messagesCountContainer.text(result);
                }
            }
        })
    },
    setColorPickers: function (colorPickers, context) {
        var items = (colorPickers != null) ? colorPickers : $('.v-colorPicker', context);
        items = items.not(".v-setColorPicker");

        items.each(function () {
            var input = $(".v-colorPickerValue", $(this));
            var component = $(".v-colorPickerDisplay", $(this));

            $(this).colorpicker({
                input: input,
                component: component
            });

            $(this).colorpicker().on("changeColor", function (e) {
                var color = e.value != null ? e.value : e.color.toString();

                $(".v-colorPickerValue", e.currentTarget).val(color);
                $(".v-colorPickerDisplay i", e.currentTarget).css("backgroundColor", color);
            });
        });

        items.addClass("v-setColorPicker");
    },
    setResizablePanels: function (leftPanel, rightPanel) {
        var parent = leftPanel.parent();

        leftPanel.resizable({
            aspectRatio: false,
            ghost: true,
            minWidth: 200,
            maxWidth: 450,
            handles: "e",
            resize: function (event, ui) {
                event.stopPropagation();
            },
            stop: function (event, ui) {
                event.stopPropagation();

                var parentWidth = parent.width();

                rightPanel.outerWidth(parentWidth - ui.size.width);

                ui.originalElement.css("height", "");

                $(window).resize();
            }
        });

        $(window).resize(function () {
            var parentWidth = parent.width();
            var leftPanelWidth = leftPanel.outerWidth(true);

            leftPanel.outerWidth(leftPanelWidth)
            rightPanel.outerWidth(parentWidth - leftPanelWidth);
        });
    },
    sessionKeepAlive: function () {
        a4.sessionCountDown.sessionNeverExpires();
    },
    bindNotificationsEvents: function () {
        $(".notifications").on("click", function () {
            $.when(a4.callServerMethod(a4.getAction("GetNotificationsList", "SystemNotification", "SystemNotification")))
                .then(function (result) {
                    $('div.notification div.body').html(result);
                });
        });

        $(document).on("click", "div.notification .h-deleteNotification", function (event) {
            var element = $(this).closest('.Element');
            var notificationId = element.attr("data-notificatioid");

            $.when(a4.callServerMethod(a4.getAction("DeleteSubscriberNotificationRefreshList", "SystemNotification", "SystemNotification"), { notificationIds: notificationId }))
                .then(function (result) {
                    $('div.notification div.body').html(result);
                    a4.updateUnreadNotificationsCount();
                });

            event.stopPropagation();
        });

        $(document).on("click", "div.notification .Element", function () {
            var notificationId = $(this).attr("data-notificatioid");

            if (notificationId) {
                modalDialog.showWindow(a4.getAction("Details", "SystemNotification", "SystemNotification", { notificationId: notificationId }), 300, 700, {
                    afterClose: function () {
                        a4.updateUnreadNotificationsCount();
                    }
                });
            }
        });
    },
    updateUnreadNotificationsCount: function () {
        var notificationsCountContainer = $("#menu-bar .action.notifications .count-bubble");

        a4.callServerMethod(a4.getAction("GetUnreadNotificationsCount", "Shared", "Home"), {
        }, function (result) {
            if (result == 0) {
                notificationsCountContainer.hide();
            }
            else {
                if (notificationsCountContainer.length == 0) {
                    $("#menu-bar .action.notifications .fa-bell").append($("<span />", { "class": "count-bubble" }).append(result));
                }
                else {
                    notificationsCountContainer.show().text(result);
                }
            }
        });
    },
    appendAntiForgeryToken: function (form) {
        if (typeof aft != "undefined" && aft != null && $(aft).length > 0 && $(form).attr("method").toUpperCase() == "POST" && !$(form).find("[name=" + $(aft).attr("name") + "]").length)
            $(form).append($(aft));
    },
    isPreviewMode: function () {
        return $("#IsPreviewMode").val() == "true";
    }
};

//---------------------------- JQuery Plugins

(function ($) {
    var check = false, isRelative = true;

    $.elementFromPoint = function (x, y) {
        if (!document.elementFromPoint) return null;

        if (!check) {
            var sl;
            if ((sl = $(document).scrollTop()) > 0) {
                isRelative = (document.elementFromPoint(0, sl + $(window).height() - 1) == null);
            }
            else if ((sl = $(document).scrollLeft()) > 0) {
                isRelative = (document.elementFromPoint(sl + $(window).width() - 1, 0) == null);
            }
            check = (sl > 0);
        }

        if (!isRelative) {
            x += $(document).scrollLeft();
            y += $(document).scrollTop();
        }

        return document.elementFromPoint(x, y);
    };

    $.fn.inlineStyle = function (prop) {
        return this.prop("style")[$.camelCase(prop)];
    };

    $.fn.isBound = function (type, fn) {
        var data = $._data(this, 'events');

        if (data === undefined || data.length === 0) {
            return false;
        }

        data = data[type];

        if (data === undefined || data.length === 0) {
            return false;
        }

        return (- 1 !== $.inArray(fn, data));
    };

    $.fn.preventDoubleSubmission = function () {
        $(this).on('submit', function (e) {
            var $form = $(this);

            $(".v-uploadingFile", $form).show();

            if ($form.data('submitted') === true) {
                // Previously submitted - don't submit again
                e.preventDefault();
            } else if ($form.attr("canResubmit") != "True") {
                // Mark it so that the next submit can be ignored
                $form.data('submitted', true);
            }
        });

        // Keep chainability
        return this;
    };

    $.fn.multiSelect = function (_options) {
        // Replacing each select with a div

        $.each(this, function () {
            var _select = this;
            var _document = $(this.ownerDocument);
            $(_select).hide();

            var _updateSelect = function () {
                var _result = _.map($(':checked', $(this).parents('.multi-select-popup')).get(), function (_checkbox) { return $(_checkbox).val(); });
                $(this).parents('.multi-select-popup').siblings('select').val(_result);

                var _display = _.map($(':checked', $(this).parents('.multi-select-popup')).get(), function (_checkbox) { return $(_checkbox).siblings('.multi-select-item-label').text(); }).join(', ');
                $(this).parents('.multi-select-popup').siblings('.multi-select-display').text(_display || $('.disableColumnsEmptyText', _document).text());
            }

            var _popup = $('<div class="multi-select-popup"></div>');
            $.each($('option', _select), function (_ix, _value) {
                var _option = this;
                $('<div class="multi-select-item" style="width: 100%"></div>').appendTo(_popup)
                    .append($('<input type="checkbox"/>').val($(_option).val()).prop('checked', _.indexOf($(_select).val(), $(_option).val()) != -1).on("change", _updateSelect))
                    .append($('<div class="multi-select-item-label"></div>').text($(_option).text()))
                    .on("click", function (_args) {
                        if (!$(_args.target).is(':input[type=checkbox]')) {
                            $(':input[type=checkbox]', this).prop('checked', !$(':input[type=checkbox]', this).is(':checked')).trigger('change');
                        }
                    });
            });

            $(_select).after(_popup);

            var _displayInfo = $('<div class="multi-select-display" style="width: 100%;">' + $('.disableColumnsEmptyText', _document).text() + '</div>');
            _displayInfo.insertAfter(_select);
            $(':input[type=checkbox]:first', _popup).trigger('change');

            var toggleDropDown = function (_element, _dropped) {
                var _show = function () {
                    var _docHeight = _document.height(); // Store the document height before displaying the options (making sure it does not change)
                    var offset = $(_element).offset();
                    var frameHeaderHeight = 0;
                    var frameOffsetTop = 0;
                    var iframeContent = $(".fancybox-iframe", top.document);

                    if (iframeContent.length > 0) {
                        frameHeaderHeight = $(".header", iframeContent.contents()).height();
                        frameOffsetTop = $(".content", iframeContent.contents()).scrollTop();
                    }

                    $(_element).siblings('.multi-select-popup')
                        .show()
                        .css('width', $(_element).innerWidth())
                        .css("left", offset.left)
                        .css("top", ((offset.top + frameOffsetTop - frameHeaderHeight) + $(_element).outerHeight()))
                        .css('z-index', _.max(_.map($(_element).parents().get(), function (_value) {
                            return $(_value).css('z-index') || 0;
                        })) + 1);

                    _document.on('mousedown.multiselect', _hide);
                };

                var _hide = function (_args) {
                    if (!_args || !_args.target // Not from an event
                        || (_args.target !== _element && !$(_args.target).hasClass('multi-select-popup') && !$(_args.target).parents('.multi-select-popup').length)) {
                        $('.multi-select-popup', _element.ownerDocument).hide();
                        _document.off('mousedown.multiselect');
                    }
                };

                if (_dropped === undefined) {
                    _dropped = $(_element).siblings('.multi-select-popup').is(':visible');
                }

                if (_dropped) {
                    _hide();
                } else {
                    _show();
                }
            };

            _displayInfo.on("mouseup", function () { toggleDropDown(this); });
            _displayInfo.on("focusin", function () {
                toggleDropDown(this, false);
            });

        });

        return this;
    };

    $.fn.disableSelection = function () {
        $(this).attr('unselectable', 'on')
            .css('-moz-user-select', 'none')
            .on('selectstart.disable', function () {
                return false;
            });
        return this;
    };

    $.fn.enableSelection = function () {
        $(this).attr('unselectable', '')
            .css('-moz-user-select', 'text')
            .off('selectstart.disable');

        return this;
    };

    $.fn.scrollIntoView = function (content, padding) {
        if (!content)
            content = $(window);

        if (!padding)
            padding = 0;

        var _docViewTop = content.scrollTop();
        var _docViewBottom = _docViewTop + content.height();

        var offsetTop = _docViewTop + $(this).offset().top;
        var _elemTop = offsetTop - padding
        var _elemBottom = offsetTop + $(this).height() + padding;

        if (_elemTop < _docViewTop) {
            content.scrollTop(_elemTop);
        } else if (_elemBottom > _docViewBottom) {
            content.scrollTop(_docViewTop + (_elemBottom - _docViewBottom));
        }

        return this;
    };

    $.fn.scrollIntoView = function () {
        var _docViewTop = $(window).scrollTop();
        var _docViewBottom = _docViewTop + $(window).height();

        var _elemTop = $(this).offset().top;
        var _elemBottom = _elemTop + $(this).height();

        if (_elemTop < _docViewTop) {
            $(window).scrollTop(_elemTop);
        } else if (_elemBottom > _docViewBottom) {
            $(window).scrollTop(_docViewTop + (_elemBottom - _docViewBottom));
        }

        return this;
    };

    $.fn.findZIndex = function () {
        return Math.max.apply(null, $.map($(this).parents(),
            function () {
                var zIndex = $(this).attr('style') && $(this).css('z-index');
                return isNaN(zIndex) ? 0 : ($(this).css('z-index') || 0);
            }));
    };

    $.fn.outerHTML = function () {
        return $('<div>').append(this.eq(0).clone()).html();
    };
})(jQuery);

//---------------------------- JQuery Extensions

$(document).ready(function () {
    // auto bind dialog for upper menu user account
    modalDialog.autoBind("accountLink", 600, 800);
    modalDialog.autoBind("notificationSettingsLink", 600, 1200);
    modalDialog.autoBind("adminAccount", 350, 600);
    modalDialog.autoBind("contactSupportLink", 420, 600);
    modalDialog.autoBind("loginpageeditorlink", "90%", "60%");

    //Cancel click in disabled buttons
    $(document).on("click", "button[disabled]", function (event) {
        event.preventDefault();
        event.stopPropagation();
    });

    //Cancel click in disabled hyperlinks
    $(document).on("click", "a,.button", function (e) {
        if ($(this).prop("disabled") || $(this).attr("disabled") == "disabled") {
            e.preventDefault();
            e.stopPropagation();
        }
    });

    //Setting the language for datepickers    
    var utcOffset = $("html").attr("data-utcoffset");

    //Setting DatePicker defaults
    $.datepicker.setDefaults($.datepicker.regional[a4.language]);
    $.timepicker.setDefaults($.extend($.timepicker.regional[a4.language], { timezone: utcOffset }));

    //Setting AutoNumeric defaults
    $.extend($.fn.autoNumeric.defaults, { aSep: '', aDec: a4.language == "fr" ? "," : ".", mDec: 2, aPad: false });

    //Setting base url
    a4.baseUrl = $("#ApplicationBaseUrl").val().toLowerCase();

    a4.host = window.location.protocol + '//' + window.location.hostname;

    a4.initializeDropDowns();

    //Preventing double submission for all forms
    $("form").preventDoubleSubmission();

    //Showing file uploading indicator
    $("form").on("submit", function (e) {
        $(".icon.uploading-file", $(this)).show();
        a4.appendAntiForgeryToken($(this));
    });

    //Prompt when leaving page
    $("form").on("click", ".h-reloadFormButton", function (e) {
        window.location = window.location;
    });

    $("form.validate-save").a4unsavedChanges({
        change: function (event, data) {
            if (data.hasChanges || $(".field-validation-error:visible, .input-validation-error:visible").length > 0) {
                data.buttons.attr("disabled", false);
            }
            else {
                data.buttons.attr("disabled", true);
            }
        },
        ready: function (event, data) {
            if ($(".field-validation-error:visible, .input-validation-error:visible").length > 0) {
                data.buttons.attr("disabled", false);
            }
        }
    });

    //Setting defaults for blockui
    $.blockUI.defaults = {
        message: voxco.icons.getIcon("loading"),
        css: {
            position: 'absolute', top: '50%', left: '50%', fontSize: '16px'
        },
        overlayCSS: {
            display: 'block', backgroundColor: '#EEE', opacity: 0.5
        },
        fadeIn: 0,
        fadeOut: 0,
        ignoreIfBlocked: true,
        baseZ: 9000,
        theme: false
    };

    $(".help-tooltip").tooltip({
        position: {
            my: "left top+5", at: "left bottom"
        }
    });

    //Setting defauls for custom scrollbars
    $.mCustomScrollbar.defaults = $.extend($.mCustomScrollbar.defaults, { theme: "dark-2", scrollInertia: 0 });

    a4.bindNotificationsEvents();

    //When the browser is on the login page, do not create the session countdown.
    //Otherwise the login page would be requested two times.
    path = window.location.pathname.toUpperCase().replace(/\//g, '');
    if (path !== "ACCOUNT" && path !== "MULTIMODE") {
        a4.sessionCountDown = new a4SessionCountDown();
        a4.sessionCountDown.init(document);
    }
});

//--------------------

String.prototype.hashCode = function () {
    var hash = 0, i, chr;
    if (this.length === 0) return hash;
    for (i = 0; i < this.length; i++) {
        chr = this.charCodeAt(i);
        hash = ((hash << 5) - hash) + chr;
        hash |= 0; // Convert to 32bit integer
    }
    return hash;
};

if (!String.prototype.startsWith) {
    String.prototype.startsWith = function (searchString, position) {
        position = position || 0;
        return this.indexOf(searchString, position) === position;
    };
}

if (!String.prototype.endsWith) {
    String.prototype.endsWith = function (searchString) {
        return this.indexOf(searchString, this.length - searchString.length) !== -1;
    };
}

if (!String.prototype.includes) {
    String.prototype.includes = function (searchString, position) {
        'use strict';

        if (searchString instanceof RegExp) {
            throw TypeError('first argument must not be a RegExp');
        }
        if (position === undefined) { position = 0; }
        return this.indexOf(searchString, position) !== -1;
    };
}
